/*
 * File:   main.c
 * Author: Y.Sakazume
 *
 * Ignition signal distributer Ver.3
 *
 * Device: 12F609
 * H/W connection:
 * GP0      Cylinder1 IG output
 * GP1		Cylinder2 IG output
 * GP2      Cylinder3 IG output
 * GP3      IGT input
 * GP4  	G1 input
 * GP5      Cylinder4 IG output
 */
#include <xc.h>
#include <stdbool.h>
#define _XTAL_FREQ  8000000

// #pragma config statements should precede project file includes.
// Use project enums instead of #define for ON and OFF.

// CONFIG
//#pragma config IDLOC0 = 0x3, IDLOC1 = 0x1, IDLOC2 = 0x0, IDLOC3 = 0x0;
#pragma config FOSC = INTOSCIO, IOSCFS = 8MHZ       // Oscillator Selection bits
#pragma config WDTE = OFF       // Watchdog Timer (WDT disabled)
#pragma config PWRTE = ON       // Power-up Timer Enable bit (Power-up Timer is enabled)
#pragma config CP = OFF         // Code Protection bit (Code protection disabled)
#pragma config MCLRE = OFF

#define IGT GP3
#define G1 COUT

void __interrupt() ISR(void) {
    static char data[]={0x01,0x02,0x04,0x20,0x27}; // 1-4気筒&グループ点火出力データ
    static char i;
    
    if(GPIF == 1){                 // GPIO状態変化(IGT検出)割込み
        GPIE=0;
        if(IGT) {
            GPIO = data[i];
            if (i<4) i++;
        }
        else {
            GPIO=0;
        }
        GPIF=0;         // can nt clear after fetching of GPIO
        GPIE=1;
    }
        if(CMIF == 1 && COUT == 0){         // コンパレーター(G1検出)割込み  
        i=0;
        CMIF=0;
    }
}

void main(void) {
    ANSEL = 0x08;      // set GP4 to analog
    //CMCON0 = 0b10000101;       // comparator setup, down slope
    CMCON0 = 0b10010101;        // up slope G1IN<RefのときCOUT=0
    CMCON1 = 0b00001010;        // ヒステリシス Vth+-45mV
    // G1閾値設定。5Vでバイアスが掛けてあるので、高い閾値ほどセンシティブとなる。
    // コイル式のセンサーの場合、暖機完了後のアイドル時が最低出力となるので、
    // この時にグループ点火にならない閾値にしておけば、それより高くなることは無い。
    // 現在一番敏感な設定にしているので、これで検出できないようなら基板側で
    // バイアスを下げないと対応できない。
    VRCON = 0b10001111;   // reference voltage = Vdd(8+VR[3:0])/32 = 3.59V@5V
    TRISIO=0x18;
    IOC3 = 1;
    CMIE = 1;

    T1CON = 0b01100111;
    INTCON = 0xc8;
    GPIO=0;
    
    while(1){
        SLEEP();
    }
}

